using System;
using System.Collections.Generic;
using System.Drawing;
using System.IO;

using VirtualLab.Programming;
using VirtualLabAPI.Core.BasicFunctions;
using VirtualLabAPI.Core.Common;
using VirtualLabAPI.Core.DataVisualization;
using VirtualLabAPI.Core.FieldRepresentations;
using VirtualLabAPI.Core.Functions;
using VirtualLabAPI.Core.GeometryDescription;
using VirtualLabAPI.Core.LightPath;
using VirtualLabAPI.Core.Materials;
using VirtualLabAPI.Core.Modules;
using VirtualLabAPI.Core.Numerics;
using VirtualLabAPI.Core.Numerics.Region2D;
using VirtualLabAPI.Core.OpticalSystems;
using VirtualLabAPI.Core.Propagation;

namespace OwnCode {
    public class VLModule : IVLModule {
        public void Run() {
            
            // Read in HFS to transform:
            HarmonicFieldsSet hfsInput = (HarmonicFieldsSet) (
                VL_GUI.SelectOpenFieldsSet("Select HFS to transform"));
            
            // Perform Fourier transform: 
            VL_Fields.FourierTransformation(hfsInput);
            
            // Deliver result;
            VL_GUI.ShowDocument(hfsInput);
            
        }
    }
}