using System;
using System.Collections.Generic;
using System.Drawing;

using VirtualLab.Programming;
using VirtualLabAPI.Core.Common;
using VirtualLabAPI.Core.FieldRepresentations;
using VirtualLabAPI.Core.Numerics;
using VirtualLabAPI.Core.Modules;

public class VLModule : IVLModule {
    public void Run() {
        int dummy = -1;
        DataArray1D daEquidistant = Globals.ActiveDocumentHistory.BrowseLastDocuments(DocumentFilter.DataArray1D,
                                                                                      out dummy,
                                                                                      "Select 1D Data Array to convert") as DataArray1D;
        
        if(!daEquidistant.IsEquidistant){
            throw new Exception("Data Array has to be equidistant");
        }
        
        if(daEquidistant.InterpolationMethodForEquidistantSampling != InterpolationMethod.Nearest){
            throw new Exception("Interpolation method of Data Array has to be nearest neighbor.");
        }
        
        List<VectorD> transitionPoints = new List<VectorD>();
        
        double firstTransition = daEquidistant.CoordinateOfFirstDataPoint - (daEquidistant.SamplingDistance / 2.0);
        
        //run through data points
        for(int runDataPoints = 0; runDataPoints <  daEquidistant.NoOfDataPoints; runDataPoints++){
            double currValue = daEquidistant.Data[0][runDataPoints].Re;
            bool addTransitionPoint = false;
            if(transitionPoints.Count == 0){
                addTransitionPoint = true;
            }else{
                if(!NumericalChecks.AreEqual(currValue, transitionPoints[transitionPoints.Count -1].Y)){
                    addTransitionPoint = true;
                }
            }
            
            if(addTransitionPoint){
                VectorD newTransition = new VectorD();
                newTransition.X =  firstTransition + (runDataPoints * daEquidistant.SamplingDistance);
                newTransition.Y = currValue;
                transitionPoints.Add(newTransition);
            }
        }
        
        //generate new data array
        double[,] coordsAndData = new double[transitionPoints.Count, 2];
        for(int runTransitionPoints = 0; runTransitionPoints < transitionPoints.Count; runTransitionPoints++){
            coordsAndData[runTransitionPoints, 0] = transitionPoints[runTransitionPoints].X;
            coordsAndData[runTransitionPoints, 1] = transitionPoints[runTransitionPoints].Y;
        }       

        double coordinateOfLastIntervalsUpperLimit = daEquidistant.CoordinateOfLastDataPoint + (daEquidistant.SamplingDistance / 2.0);;
        
        DataArray1D transitions = new DataArray1D(coordsAndData,
                                                  daEquidistant.PhysicalPropertiesOfDataEntries[0],
                                                  daEquidistant.CommentsOfDataEntries[0],
                                                  daEquidistant.PhysicalPropertyOfCoordinates,
                                                  daEquidistant.CommentOfCoordinates,
                                                  coordinateOfLastIntervalsUpperLimit);

        VL_GUI.ShowDocument(transitions,"TransitionPoints");
    }
}
